import Utilities.gui_creator as gc
import Utilities.plot_creator as pc
import numpy as np
import tkinter.filedialog as fd
import scipy.optimize as opt

fname = fd.askopenfilename()
t, r = np.loadtxt(fname, delimiter=',', usecols=(0,1),
                  unpack=True)

root = gc.create_window(title='Thermistor Residuals Plot',
                        size='1000x500')
control_box, right_frame = gc.create_frames(root)
ax, canvas = pc.create_plot(right_frame)

x = np.log(r*1000)
y = 1/(t + 273.15)
z = t + 273.15

def linearized_sh(x, a, b, d):
    return a + b*x + d*x**3

def nonlinear_sh(x, a, b, d):
    return 1/(a + b*x + d*x**3)

def polynomial(x, a, b, c, d):
    return a + b*x + c*x**2 + d*x**3

def beta_function(x, a, b):
    return a + b*x


p0 = 1.e-3, 1.e-4, 1e-7
popt, pcov = opt.curve_fit(linearized_sh, x, y, p0)
#popt,pcov = opt.curve_fit(nonlinear_sh, x, z, p0)
c = 0
a, b, d = popt

#p0 = 1.e-3, 1.e-4, 1e-7, 1e-7
#popt, pcov = opt.curve_fit(polynomial, x, y, p0)
#a, b, c, d = popt

#p0 = 1.e-3, 1.e-4
#popt, pcov = opt.curve_fit(beta_function, x, y, p0)
#c, d = 0, 0
#a, b = popt

gc.create_indicator(control_box, label_1='A',
                    label_2=f'{a:.8e}')
gc.create_indicator(control_box, label_1='B', 
                    label_2=f'{b:.8e}')
gc.create_indicator(control_box, label_1='C', 
                    label_2=f'{c:.8e}')
gc.create_indicator(control_box, label_1='D',
                    label_2=f'{d:.8e}')

y_fit = a + b*x + c*x**2 + d*x**3
t_fit = 1/y_fit - 273.15

residual = t - t_fit

pc.update_plot(ax, canvas, t, residual,
               label_x='Temperature (deg Celsius)',
               label_y='Residual (deg Celsius)',
               marker='o')
